<?php

add_action( 'wp_enqueue_scripts', 'porto_child_css', 1001 );

// Load CSS
function porto_child_css() {
	// porto child theme styles
	wp_deregister_style( 'styles-child' );
	wp_register_style( 'styles-child', esc_url( get_stylesheet_directory_uri() ) . '/style.css' );
	wp_enqueue_style( 'styles-child' );

	if ( is_rtl() ) {
		wp_deregister_style( 'styles-child-rtl' );
		wp_register_style( 'styles-child-rtl', esc_url( get_stylesheet_directory_uri() ) . '/style_rtl.css' );
		wp_enqueue_style( 'styles-child-rtl' );
	}
}


/**
 * TITULO
 */
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_title', 5 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_title', 0 );

/**
 * LA CLASIFICACION
 */
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 6 );

/**
 * DESCRIPCION
*/
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 150 );

/**
 * BOTON COMPRAR
 * 
 */
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 120 );

/**
 * PRECIO
 * add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
 */
 remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );

/**
 * DATOS DE PRODUCTO SKU
 * remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 4 );
 */
 
add_filter( 'wc_product_sku_enabled', '__return_false' );

/** Remover menú desplegable "Ordenar por" en WooCommerce **/
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );

/* QUITAR PRECIO DE SEO GOOGLE */

add_filter( 'woocommerce_structured_data_product_offer', '__return_empty_array' );


/* Eliminar precio de rich snippets de productos WooCommerce 
function cl_product_delete_meta_price( $product = null ) {
	if ( ! is_object( $product ) ) {
		global $product;
	}
	if ( ! is_a( $product, 'WC_Product' ) ) {
		return;
	}
	if ( '' !== $product->get_price() ) {
		$shop_name = get_bloginfo( 'name' );
		$shop_url  = home_url();
		$markup_offer = array(
			'@type'         => 'Offer',
			'availability'  => 'https://schema.org/' . $stock = ( $product->is_in_stock() ? 'InStock' : 'OutOfStock' ),
			'sku'           => $product->get_sku(),
			'image'         => wp_get_attachment_url( $product->get_image_id() ),
			'description'   => $product->get_description(),
			'seller'        => array(
				'@type' => 'Organization',
				'name'  => $shop_name,
				'url'   => $shop_url,
			),
		);
	}
	return $markup_offer;
}
add_filter( 'woocommerce_structured_data_product_offer', 'cl_product_delete_meta_price' );

*/

/* woocommerce-ocultar-precios-usuarios-no-registrados 

add_filter( 'woocommerce_variable_sale_price_html', 'update_price_html', 10, 2 );
add_filter( 'woocommerce_variable_price_html', 'update_price_html', 10, 2 );
add_filter( 'woocommerce_get_price_html','update_price_html', 999, 2 );

function update_price_html( $html, $product ) {

    if(!is_user_logged_in()) {  // Si el usuario no está logueado
        add_filter( 'woocommerce_is_purchasable', '__return_false');
        $html = "";
        return $html;
    } else {
        return $html;
    }
}

*/
